<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    public function neighborhoods()
    {
        return $this->belongsTo('App\Models\Neighborhood', 'neighborhood_id');
    }

    public function restaurants()
    {
        return $this->belongsToMany('App\Models\Restaurant', 'reviews')->withPivot('coment','emoji');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function notifications()
    {
        return $this->morphMany('App\Models\Notification', 'users');
    }

    public function tokens()
    {
        return $this->morphMany('App\Models\Token', 'users');
    }

}